#include <Core/Core.h>
#include <NetworkProxy/NetworkProxy.h>

using namespace Upp;

CONSOLE_APP_MAIN
{
	NetworkProxy::Trace();

	const char *public_socks_proxy = "127.0.0.1"; // Change this to your preferred public proxy.
	const char *target_hosts[] = {
		"ftp.mozilla.org",
		"ftp.freebsd.org", 
		"ftp.kde.org",
		"ftp.microsoft.com"
	};
	
	Array<TcpSocket> sockets;
	Array<SocksProxy> proxies;
	SocketWaitEvent event;

	for(int i = 0; i < 4; i++) {
		SocksProxy& proxy = proxies.Add(new SocksProxy(sockets.Add()));
		proxy.Socks5().Host(public_socks_proxy).Port(1080);
		proxy.Auth("anonymous", "anonymous");
		proxy.Timeout(10000);
		proxy.StartConnect(target_hosts[i], 21);
		sockets[i].Timeout(0);
		event.Add(sockets[i]);
	}
	
	while(proxies.GetCount()) {
		for(int i = 0; i < proxies.GetCount(); i++) {
			event.Wait(10);
			SocksProxy& proxy = proxies[i];
			proxy.Do();
			if(!proxy.InProgress()) {
				if(proxy.IsSuccess()) {
					TcpSocket& socket = proxy.GetSocket();
					socket.Timeout(10000);
					Cout() 	<< "Succesfully connected to target host via SOCKS" << proxy.GetType() << " server " 
							<< "(IP: " << socket.GetPeerAddr() << ").\r\n";
					Cout() 	<< socket.GetLine() << "\r\n"; 
				}
				else
				if(proxy.IsFailure()) {
					Cout() 	<< "Proxy connection failed. Reason: " << proxy.GetErrorDesc() << "\r\n";
					Cout() 	<< "Restarting...\r\n";
//					proxy.Restart();
//					continue;
				}
				proxies.Remove(i);
				break;
			}
			Sleep(1);
		}
	}
}